/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#ifndef WAYLANDBACKEND_WLCLIENTCONTEXT
#define WAYLANDBACKEND_WLCLIENTCONTEXT 1

#include <pthread.h>

#include "WLSurfaceEvent.hpp"
struct wl_display;
struct wl_event_queue;

namespace WaylandBackend
{
class GlobalEventHandler;
class WLWindowController;

class WLClientContext
{
public:
    WLClientContext(const char * connectionName);
    ~WLClientContext();
    
    int dispatchEvents(int timeout);
    
    void* getDisplay();
    void* getWlOuput(const char *outputName);
    void* getActiveShell();
    
    WLWindowController* createWindowController(WLSurfaceEvent *wlInputHandler);
    int destroyWindowController(WLWindowController *wlWinCtrl);
    
private:
    struct wl_display* 		_wlDisplay;
    struct wl_event_queue*  _wlEventQ;
    GlobalEventHandler*     _wlEventHandler;
    pthread_mutex_t        _dispatchProtectMutex;
    
    int pollForEvents(short int events, int timeout);
    int flushWLDisplay();
};

}

#endif
